<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package The_Priscilla_Davis_Theme
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <hr>
    <div class="bel-hero-blog">
      <?php the_priscilla_davis_theme_post_thumbnail(); ?>
    </div>

    <div class="bel-dtinfo">
      <div class="row">
        <div class="col-12 col-sm-6">
          <div class="d-flex ">
            <div class="flex-shrink-0">
              <p class="bel-date"><?php echo get_the_date('F j, Y,'); ?></p>
            </div>
            <div class="flex-grow-1 ms-3">
              <p class="bel-date"><?php echo get_post_time("h:i A"); ?></p>
            </div>
          </div>

          <h2 class="bel-title"><?php echo the_title() ?> </h2>
        </div>

        <div class="col-12 col-sm-6 ">
          <div class="d-flex align-items-center gap-3 justify-content-md-end">
            <img style="width: 78px;" src="<?php echo get_avatar_url(get_the_author_meta('ID')); ?>" alt="<?php echo get_the_author() ?>" class="rounded-circle">
            <h4 class="bel-ify ml-3"> <?php echo get_the_author() ?> </h4>
          </div>
        </div>
      </div>
    </div>

    <hr>

    <div class="bel-content">
        <?php the_content(); ?>
    </div>
</article><!-- #post-<?php the_ID(); ?> -->