<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package The_Priscilla_Davis_Theme
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>    
    <div class="bel_blog-post bel_blog-post<?php echo the_ID(); ?> bel_blog-margin-top">
        <img src="<?php echo get_the_post_thumbnail_url() ?>" alt="Blog Post image" class="img-fluid bel_blog-img" loading="lazy">
        
			<?php	
					the_title( '<h2>', '</h2>' );
			?>

        <p>
            <a href="<?php echo esc_url( get_permalink() ) ?>" rel="bookmark">
                <?php 
                    $words_content = wp_strip_all_tags( get_the_content() );
                    $split_words = explode(" ", $words_content);
                    $the_words_to_show = array_slice($split_words, 0, 15);
                echo $the_words_to_show = implode(' ', $the_words_to_show)."...";
                ?>
            </a>
        </p>
        <div class="bel_inner-blog-content-wrap">
        <img src="<?php echo get_avatar_url( get_the_author_meta( 'ID' )); ?>" alt="<?php echo get_the_author() ?>" loading="lazy" class="img-fluid bel_blog-inner-img">
            <div class="bel_blog-inner-text-wrap">
                <h4 class="bel_blog-poster-name"><?php echo get_the_author() ?></h4>
                <span>.</span>
                <h4 class="bel_blog-post-date"><?php echo get_the_date( 'F j, Y' ); ?></h4>
            </div>
            
        </div>
    </div>
</article><!-- #post-<?php the_ID(); ?> -->

