<?php

/** Template Name: Home Page **/
get_header();

?>
<!-- Hero Section Start -->
<section class="wrap">
    <div class="bel_main-banner ">
        <div class=" bel_myslider slide1 " style="display: block;" loading="lazy">
            <div class="bel_main-banner-content-wrappper hero-text container">
                <h1>Your Partner in <br> Transforming Potential <br> into Excellence</h1>
                <p>Unlocking Hidden Capabilities, Delivering <br> Outstanding Results.</p>
                <div class="hero-btn-wrapper">
                    <a class="hero-btn-1" href="<?php echo get_permalink(get_page_by_title('Contact')); ?>">Get started</a>
                    <a class="hero-btn-2" href="<?php echo get_permalink(get_page_by_title('Contact')); ?>">Contact us</a>
                </div>
            </div>
        </div>

        <div class=" bel_myslider slide2">
            <div class="bel_main-banner-content-wrappper hero-text container" loading="lazy">
                <h1>Your Partner in <br> Transforming Potential <br> into Excellence</h1>
                <p>Unlocking Hidden Capabilities, Delivering <br> Outstanding Results.</p>
                <div class="hero-btn-wrapper">
                    <a class="hero-btn-1" href="<?php echo get_permalink(get_page_by_title('Contact')); ?>">Get started</a>
                    <a class="hero-btn-2" href="<?php echo get_permalink(get_page_by_title('Contact')); ?>">Contact us</a>
                </div>
            </div>
        </div>

        <a onclick="plusSlides(-1)" class="prev arrow hide" id="slide-arrow-prev">&#10094;</a>
        <a onclick="plusSlides(1)" class="next arrow hide" id="slide-arrow-next">&#10095;</a>
        
        <div class="dotswrapper">
            <span class="dot hide" onclick="currentSlide(1)"></span>
            <span class="dot hide" onclick="currentSlide(2)"></span>
        </div>
    </div>
</section>
<!-- Hero Section End -->

<!-- About Section Start -->
<section class="bel_home-about-section bel_ptb">
    <div class="container">
        <div class="about-wrapper">
            <div class="about-textcontent">
                <h1>About Us</h1>
                <h2>WE ARE LEADING IN EVERY ASPECT</h2>
                <p>Welcome to Pricilla Davis Ltd, where potential meets expertise.
                    We specialise in harnessing latent abilities and turning them into polished, market-leading solutions. Our commitment to
                    innovation and efficiency sets us apart, as we establish the systems and procedures that drive your success.</p>

                <a class="about-btn" href="<?php echo get_permalink(get_page_by_title('About')); ?>">About Us</a>
            </div>
            <div class="about-img img-fluid">
                <img src="<?php echo get_template_directory_uri() . '/assets/images/about-us-img.png' ?>" alt="About Us Image" loading="lazy">
            </div>
        </div>

        <div class="about-counter">
            <div class="about-data1 about-data">
                <div style="display: inline-flex;">
                    <h3 class="num-count" data-count="150">0</h3>
                    <h3 class="num-plus">+</h3>
                </div>

                <h4 class="num-text">completed <br> projects</h4>
            </div>
            <div class="about-data2 about-data">
                <div style="display: inline-flex;">
                    <h3 class="num-count" data-count="10">0</h3>
                    <h3 class="num-plus">+</h3>
                </div>
                <h4 class="num-text">years of <br> experience</h4>
            </div>
            <div class="about-data3 about-data">
                <div style="display: inline-flex;">
                    <h3 class="num-count" data-count="5">0</h3>
                    <h3 class="num-plus">k+</h3>
                </div>
                <h4 class="num-text">trained <br> in <span class="tvet">tvet</span></h4>
            </div>
            <div class="about-data4 about-data">
                <div style="display: inline-flex;">
                    <h3 class="num-count" data-count="100">0</h3>
                    <h3 class="num-plus">+</h3>
                </div>
                <h4 class="num-text">machines <br> procured</h4>
            </div>
        </div>
    </div>
</section>
<!-- About Section End -->

<!-- OUR bel_services SECTION START -->
<?php get_template_part( 'template-parts/services-section'); ?>
<!-- OUR bel_services SECTION END -->

<!-- MEET CONSULTANTS SECTION START -->
<?php get_template_part( 'template-parts/team-section'); ?>
<!-- MEET CONSULTANTS SECTION END -->

<!-- LATEST WORK SECTION START -->
<section class="bel_latest-work-area">
    <div class="container">
        <div class="bel_latest-work-header">
            <h1>About Pricilla Davies</h1>
            <h2>OUR LATEST WORK</h2>
        </div>
        <div class="bel_latest-work-wrapper">
            <?php
                $project_args = array( 'post_type' => 'project', 'posts_per_page' => 3 );
                $project_query = new WP_Query( $project_args );
                if($project_query->have_posts()): 
                    
                    while ($project_query->have_posts()):
                        $project_query->the_post();
                        $project_location = get_post_meta(get_the_ID(),'location',true);
                        ?>
                        <div class="bel_latest-works">
                            <img class="bel-project-image" src="<?php echo get_the_post_thumbnail_url() ?>" alt="<?php the_title(); ?>" class="img-fluid">
                            <div class="bel_latest-work-text">
                                <h3><a href="<?php echo esc_url(get_permalink()) ?>"><?php the_title(); ?></a></h3>
                                <h4><?php echo $project_location ?></h4>
                            </div>
                        </div>
                    <?php
                    endwhile;
                endif;?>
        </div>
    </div>
</section>
<!-- LATEST WORK SECTION END -->

<!-- OUR bel_clients SECTION START -->
<section class="bel_our-bel_clients-area">
    <div class="container">
        <div class="bel_our-bel_clients-header">
            <h1>trust and worth</h1>
            <h2>our clients</h2>
        </div>

        <div class="bel_clients">
            <img class="client" src="<?php echo get_template_directory_uri() . '/assets/images/icons/cailleau-herboristerie.png' ?>" alt="Our bel_clients" loading="lazy">
            <img class="client" src="<?php echo get_template_directory_uri() . '/assets/images/icons/kiara-personnel.png' ?>" alt="Our bel_clients" loading="lazy">
            <img class="client" src="<?php echo get_template_directory_uri() . '/assets/images/icons/koa.png' ?>" alt="Our bel_clients" loading="lazy">
        </div>

        <!-- Our client Mobile View -->
        <div class="swiper mySwiper bel_clients-carousel" id="bel_clients-mobile">
            <div class="swiper-wrapper">
                <div class="swiper-slide">
                    <img class="client" src="<?php echo get_template_directory_uri() . '/assets/images/icons/cailleau-herboristerie.png' ?>" alt="Our bel_clients" loading="lazy">
                </div>
                <div class="swiper-slide">
                    <img class="client" src="<?php echo get_template_directory_uri() . '/assets/images/icons/kiara-personnel.png' ?>" alt="Our bel_clients" loading="lazy">
                </div>
                <div class="swiper-slide">
                    <img class="client" src="<?php echo get_template_directory_uri() . '/assets/images/icons/koa.png' ?>" alt="Our bel_clients" loading="lazy">
                </div>
            </div>
        </div>
    </div>
</section>
<!-- OUR bel_clients SECTION END -->


<!-- TESTIMONIAL SECTION START -->
<!-- <section class="bel_testimonial-area">
    <div class="bel_testimonial-header">
        <h1>what our clients say</h1>
        <h2>testimonials</h2>
    </div>
    <div class="bel_container-carou">
        <div class="section-wrap slider-section">
            <div class=" slider-column">
                <span class="swiper-button-prev"></span>

                <div class="swiper swiper-slider bel_testimonial-slider">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide card">
                            <div class="card-content">
                                <p>
                                    "Priscilla Davis Limited delivers every time. Their international procurement services are
                                    swift and reliable, making our projects hassle-free. Plus, their project management expertise
                                    adds real value to our operations."
                                </p>
                                <div class="card-inner-content">
                                    <img src="<?php echo get_template_directory_uri() . '/assets/images/testimonial/jd-mason-UKSoi-H2n_k-unsplash1.png ' ?>" alt="testimonial image" loading="lazy">
                                    <div class="card-inner-text">
                                        <h3>Linda Turner</h3>
                                        <h4>COO, GlobalTech Solutions</h4>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="swiper-slide card">
                            <div class="card-content">
                                <p>
                                    "Priscilla Davis Limited delivers every time. Their international procurement services are
                                    swift and reliable, making our projects hassle-free. Plus, their project management expertise
                                    adds real value to our operations."
                                </p>
                                <div class="card-inner-content">
                                    <img src="<?php echo get_template_directory_uri() . '/assets/images/testimonial/jd-mason-UKSoi-H2n_k-unsplash1.png ' ?>" alt="testimonial image" loading="lazy">
                                    <div class="card-inner-text">
                                        <h3>Linda Turner</h3>
                                        <h4>COO, GlobalTech Solutions</h4>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="swiper-slide card">
                            <div class="card-content">
                                <p>
                                    "Priscilla Davis Limited delivers every time. Their international procurement services are
                                    swift and reliable, making our projects hassle-free. Plus, their project management expertise
                                    adds real value to our operations."
                                </p>
                                <div class="card-inner-content">
                                    <img src="<?php echo get_template_directory_uri() . '/assets/images/testimonial/jd-mason-UKSoi-H2n_k-unsplash1.png ' ?>" alt="testimonial image" loading="lazy">
                                    <div class="card-inner-text">
                                        <h3>Linda Turner</h3>
                                        <h4>COO, GlobalTech Solutions</h4>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="swiper-slide card">
                            <div class="card-content">
                                <p>
                                    "Priscilla Davis Limited delivers every time. Their international procurement services are
                                    swift and reliable, making our projects hassle-free. Plus, their project management expertise
                                    adds real value to our operations."
                                </p>
                                <div class="card-inner-content">
                                    <img src="<?php echo get_template_directory_uri() . '/assets/images/testimonial/jd-mason-UKSoi-H2n_k-unsplash1.png ' ?>" alt="testimonial image" loading="lazy">
                                    <div class="card-inner-text">
                                        <h3>Linda Turner</h3>
                                        <h4>COO, GlobalTech Solutions</h4>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="swiper-slide card">
                            <div class="card-content">
                                <p>
                                    "Priscilla Davis Limited delivers every time. Their international procurement services are
                                    swift and reliable, making our projects hassle-free. Plus, their project management expertise
                                    adds real value to our operations."
                                </p>
                                <div class="card-inner-content">
                                    <img src="<?php echo get_template_directory_uri() . '/assets/images/testimonial/jd-mason-UKSoi-H2n_k-unsplash1.png ' ?>" alt="testimonial image" loading="lazy">
                                    <div class="card-inner-text">
                                        <h3>Linda Turner</h3>
                                        <h4>COO, GlobalTech Solutions</h4>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="swiper-slide card">
                            <div class="card-content">
                                <p>
                                    "Priscilla Davis Limited delivers every time. Their international procurement services are
                                    swift and reliable, making our projects hassle-free. Plus, their project management expertise
                                    adds real value to our operations."
                                </p>
                                <div class="card-inner-content">
                                    <img src="<?php echo get_template_directory_uri() . '/assets/images/testimonial/jd-mason-UKSoi-H2n_k-unsplash1.png ' ?>" alt="testimonial image" loading="lazy">
                                    <div class="card-inner-text">
                                        <h3>Linda Turner</h3>
                                        <h4>COO, GlobalTech Solutions</h4>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>
                <span class="swiper-button-next"></span>
            </div>
        </div>
    </div>

</section> -->

<!-- TESTIMONIAL SECTION START -->

<!-- EVENTS SECTION START -->
<section class="bel_events-area">
    <div class="container">
        <div class="bel_event-header">
            <h1>check out our recent events</h1>
        </div>

        <div class="bel_events-container">
            <?php
            $args = array('post_type' => 'events', 'posts_per_page' => 10);
            $the_query = new WP_Query($args);
            ?>
            <?php if ($the_query->have_posts()) :

                while ($the_query->have_posts()) :
                    $the_query->the_post(); ?>

                    <div class="bel_event">
                        <?php 
                            $event_query = get_post_meta(get_the_ID(),'event_date',true);
                            $event_month = date("F",strtotime($event_query));
                            $event_day = date("j",strtotime($event_query));
                            $event_time = get_post_meta(get_the_ID(),'event_time',true);
                            $event_time = date("g:i A", strtotime($event_time));
                        ?>
                        <h3><?php echo $event_month ?></h3>
                        <h4><?php echo $event_day?></h4>
                        <h2><a href="<?php echo esc_url(get_permalink()) ?>"><?php the_title(); ?></a></h2>
                        <div class="bel_event-inner-text">
                            <p class="bel_event-inner-text1"><?php echo get_post_meta(get_the_ID(),'location',true);?></p>
                            <p class="bel_event-inner-text2"><?php echo $event_time?> (WAT)</p>
                        </div>
                    </div>
            <?php
                endwhile;
            endif;
            ?>
        </div>
        <div class="bel_event-btn-wrapper">
            <a class="bel_event-btn" href="<?php echo get_permalink(get_page_by_title('Events')); ?>">Load more events</a>
        </div>
    </div>
</section>
<!-- EVENTS SECTION END -->


<?php
get_footer(); ?>