<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package The_Priscilla_Davis_Theme
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>


<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head(); ?>
	<script>
		var firstMBar = "<?php echo get_template_directory_uri() . '/assets/images/menu-bar.svg'; ?>";
		var secondMBar = "<?php echo get_template_directory_uri() . '/assets/images/menu-bar-alt.svg'; ?>";
	</script>
</head>

<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>
	<div id="page" class="site">
		<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'the-priscilla-davis-theme'); ?></a>

		<header id="masthead" class="site-header">
			<main>
				<div class="bel_header">
					<div class="container">
						<nav class="navbar navbar-expand-sm">
							<div class="container-fluid">
								<a class="navbar-brand logo" href="<?php echo get_site_url() . '/' ?>">
									<?php
									if (has_custom_logo()) :
										$image = wp_get_attachment_image_src(get_theme_mod('custom_logo'), 'full');
									?>

									<?php
										the_custom_logo();
									else :
										$image = get_template_directory_uri() . '/assets/images/logo.svg';
									?>
										<img src="<?php echo $image ?>">
									<?php
										endif;
									?>
								</a>

								<div class="bel_deskonly">
									<div class="bel_desknav">
										<?php echo wp_nav_menu(array(
											'menu' => 'main',
											'container' => 'nav',
											'container_class' => 'nav-wrapper',
										)); ?>
									</div>
									<a class="btn bel_btn-secondary" href="<?php echo get_permalink(get_page_by_title('Contact')); ?>">CONTACT US</a>
								</div>

								<button class="navbar-toggler collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#bel_collapsibleNavbar">
									<span class=""><img src="<?php echo get_template_directory_uri() . '/assets/images/menu-bar.svg'; ?>"></span>
								</button>
								<div class="collapse navbar-collapse" id="bel_collapsibleNavbar">
								<?php echo wp_nav_menu(array(
											'menu' => 'main',
											'container' => 'nav',
											'container_class' => 'nav-wrapper',
										)); ?>
								</div>
							</div>
						</nav>
					</div>
				</div>
			</main>
		</header><!-- #masthead -->