<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package The_Priscilla_Davis_Theme
 */

?>
<footer>
	<div class="container">
		<div class="row">
			<div class="col-12 col-md-3">
				<div class="footer-logo-wrapper">
					<img class="logo" src="<?php echo get_template_directory_uri() . '/assets/images/footer-icon.png' ?>" alt="footer-logo">
				</div>

				<div class="bel_social-links">
					<a href=""><i class="bi bi-facebook"></i></a>
					<a href=""><i class="bi bi-youtube"></i></a>
					<a href=""><i class="bi bi-instagram"></i></a>
					<a href=""><i class="bi bi-twitter-x"></i></a>
				</div>
			</div>

			<div class="col-12 col-md-2">
				<h3 class="footer-categories">Quick Links</h3>
				<ul class="footer-cat-links">
					<li><a href="<?php get_permalink(get_page_by_title('Homepage')) ?>"><span>Home</span></a></li>
					<li><a href="<?php echo get_permalink(get_page_by_title('About')); ?>"><span>About us</span></a></li>
					<li><a href="<?php echo get_permalink(get_page_by_title('Blog')); ?>"><span>Blog</span></a></li>
					<li><a href="<?php echo get_permalink(get_page_by_title('Events')); ?>"><span>Events</span></a></li>
					<!-- <li><a href=""><span>Club</span></a></li> -->
				</ul>
			</div>

			<div class="col-12 col-md-2">
				<h3 class="footer-categories">Our Services</h3>
				<ul class="footer-cat-links">
					<li><a href=""><span>Our health products</span></a></li>
					<li><a href=""><span>ICT services</span></a></li>
					<li><a href=""><span>Consultancy</span></a></li>
					<li><a href=""><span>TVET</span></a></li>
					<li><a href=""><span>Business support</span></a></li>
				</ul>
			</div>

			<div class="col-12 col-md-3">
				<div>
					<h3 class="footer-categories">Office Address</h3>
					<p class="footer-cat-p footer-office-address"><span>No. 8, Embu street, <br> Wuse II, Abuja.</span></p>
				</div>

				<div>
					<h3 class="footer-categories footer-phone-numbers">Phone Numbers</h3>
					<p class="footer-cat-p footer-cat-pp "><span>+234(0) 909 349 9995</span></p>
					<p class="footer-cat-p"><span>+234(0) 805 831 6452</span></p>
				</div>
			</div>

			<div class="col-12 col-md-2">
				<h3 class="footer-categories ">Working Hours</h3>
				<p class="footer-cat-p footer-working-hours"><span>Mon - Sat <br> 08:00 - 17:50</span></p>
				<p class="footer-cat-p"><span>Sun. (closed)</span></p>
			</div>
		</div>

		<div class="">
			<div class="bel-footer-line"></div>
		</div>

		<div class="row w-100 bel-copyrights" id="">
			<div class="d-md-flex justify-content-md-between">
				<p>Copyright &copy; <?php echo date("Y"); ?> Priscilla Davis Limited </p>
				<p><strong>Designed by</strong> <a style="color: #E49D32" href="https://belomth.com/">Belomth Digitals</a></p>
			</div>
		</div>
	</div>
	</div>
</footer>
</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>