
// HERO SECTION BANNER CAROUSEL START
const bannerSlides = document.querySelectorAll('.bel_myslider'),
    dot = document.querySelectorAll('.dot');

let counter = 1;
slideFunc(counter);

let timer = setInterval(autoslide, 7000);

function autoslide(){
  counter += 1;
  slideFunc(counter);
}

function plusSlides(n){
  counter += n;
  slideFunc(counter);
  resetTimer()
}

function currentSlide(n){
    counter = n;
    slideFunc(counter);
    resetTimer();
}

function resetTimer() {
  clearInterval(timer);
  timer = setInterval(autoslide, 7000);
}

function slideFunc(n) {
  for (let i = 0; i < bannerSlides.length; i++){
    bannerSlides[i].style.display = 'none';
  }

  for (let i = 0; i < dot.length; i++){
    dot[i].classList.remove('active');
  }

  if (n > bannerSlides.length){
    counter = 1;
  }
  if (n < 1){
    counter = bannerSlides.length;
  }
  bannerSlides[counter -1].style.display = 'block';
  dot[counter - 1].classList.add('active');
}
// HERO SECTION BANNER CAROUSEL END


//ABOUT US PAGE NUMBER COUNTER START

 const counters = document.querySelectorAll('.num-count');
 const speed = 200;

 counters.forEach( counter => {
   const updateCount = () => {
      const value = +counter.getAttribute('data-count');
      const data = +counter.innerText;
     
      const time = value / speed;
     if(data < value) {
          counter.innerText = Math.ceil(data + time);
          setTimeout(updateCount, 1);
        }else{
          counter.innerText = value;
        }
     
   }
   
   updateCount();
});


// <!-- Initialize Swiper FOR bel_clients SLIDES
var swiper = new Swiper(".bel_clients-carousel", {
  slidesPerView: 1,
  centeredSlides: false,
  // centeredSlidesBounds: true,
  spaceBetween: 20,
  loopAddBlankSlides: false,
  slidesPerGroupSkip: 3,
  // loop: true,
  slidesPerGroup: 3,
  grabCursor: true,
  keyboard: {
    enabled: true
  },
  breakpoints: {
        // when window width is >= 320px
        320: {
          slidesPerView: 2,
          spaceBetween: 20,
        },
        // when window width is >= 480px
        480: {
          slidesPerView: 3,
          spaceBetween: 50,
          slidesPerGroup: 3,

        },
        // when window width is >= 640px
        640: {
          slidesPerView: 3,
          spaceBetween: 40
        },
    769: {
      slidesPerView: 3,
      spaceBetween: 40
    },
    1024: {
      slidesPerView: 4,
      spaceBetween: 50
    }
  },
  autoplay: {
    delay: 2500
  }
});


// <!-- Initialize Swiper FOR TESTIMONIAL SLIDES
var swiper = new Swiper(".bel_testimonial-slider", {
  // Optional parameters
  slidesPerView: 1,
  grabCursor: false,
  freeMode: false,
  spaceBetween: 30,
  loop: true,
  mousewheel: false,
  keyboard: {
    enabled: true
  },

  // Enabled autoplay mode
  autoplay: {
    delay: 5000,
    disableOnInteraction: false
  },

  // If we need pagination
  // pagination: {
  //   el: ".swiper-pagination",
  //   dynamicBullets: false,
  //   clickable: true
  // },

  // If we need navigation
  
  navigation: {
    nextEl: ".swiper-button-next",
    prevEl: ".swiper-button-prev",
  },
  breakpoints: {
  
    576: {
      slidesPerView: 2,
      spaceBetween: 20
    },
    768: {
      slidesPerView: 2,
      // spaceBetween: 20
      slidesPerGroup: 2
    },
    992: {
      slidesPerView: 2,
    }
  }
})



$(document).ready(function () {
    $(".navbar-toggler").click(function(){
        if($(this).hasClass('collapsed')) {
            $(".bel_header").css("backgroundColor","#fff");
            $(".bel_header .navbar-toggler img").attr("src","/assets/images/menu-bar.svg");
        } else {
            $(".bel_header").css("backgroundColor","#00352D");
            $(".bel_header .navbar-toggler img").attr("src","/assets/images/menu-bar-alt.svg");
        }
    });
});

