<?php
/** Template Name: Events **/
get_header();

?>


        <!--Events Hero Section Start -->
        <section class="bel_events-hero">
            <div class="container bel_events-hero-text">
                <h1>Events</h1>
            </div>
        </section>
        <!--Events Hero Section End -->

       <!-- Recent Events Start -->
        <section class="bel_recent-events-section bel_ptb">
            <div class="container">
                <div class="bel_recent-events-header">
                    <h2>Recent Projects</h2>
                </div>

                <div class="bel_recent-events-wrapper">
            <?php
                $project_args = array( 'post_type' => 'project', 'posts_per_page' => 3 );
                $project_query = new WP_Query( $project_args );
                if($project_query->have_posts()): 
                    
                    while ($project_query->have_posts()):
                        $project_query->the_post();
                        $project_location = get_post_meta(get_the_ID(),'location',true);
                        ?>
                    <div class="bel_recent-event">
                    <img src="<?php echo get_the_post_thumbnail_url() ?>" alt="<?php the_title(); ?>" class="img-fluid">
                        <div class="bel_recent-event-text">
                                <h3><a href="<?php echo esc_url(get_permalink()) ?>"><?php the_title(); ?></a></h3>
                                <h4><?php echo $project_location ?></h4>
                        </div>
                    </div>
                    
                    <?php
                    endwhile;
                endif;?>
                </div>
            </div>
        </section>
       <!-- Recent Events Section End -->


       <!-- ALL EVENTS SECTION START -->
        <section class="bel_all-events-area bel_ptb">
            <div class="container">
                <div class="bel_all-events-header">
                    <h2>All Events</h2>
                </div>

                <div class="bel_all-events-wrapper">
                    <div class="bel_all-events-row1">
                        <?php
                        $f2args = array('post_type' => 'events', 'posts_per_page' => 2);
                        $f2the_query = new WP_Query($f2args);
                        ?>
                        <?php if ($f2the_query->have_posts()) :

                            while ($f2the_query->have_posts()) :
                                $f2the_query->the_post();
                        
                        ?>
                        <div class="bel_all-event bel_all-event-col1">
                            <img src="<?php echo get_the_post_thumbnail_url() ?>" alt="<?php the_title() ?>" class="img-fluid">
                            <div class="bel_all-event-text">
                        <h3><a href="<?php echo esc_url(get_permalink()) ?>"><?php the_title(); ?></a></h3>
                                <h4><?php echo get_post_meta(get_the_ID(),'location',true);?></h4>
                            </div>
                        </div>
                    <?php endwhile;
                    endif;
                    ?>
                    </div>
                    <div class="bel_all-events-row2">
                        <?php
                        $af2args = array('post_type' => 'events', 'offset' => 2);
                        $af2the_query = new WP_Query($af2args);
                        ?>
                        <?php if ($af2the_query->have_posts()) :

                            while ($af2the_query->have_posts()) :
                                $af2the_query->the_post();
                        
                        ?>
                        <div class="bel_all-event bel_all-event-col3">
                            <img src="<?php echo get_the_post_thumbnail_url() ?>" alt="<?php the_title() ?>" class="img-fluid">
                            <div class="bel_all-event-text">
                        <h3><a href="<?php echo esc_url(get_permalink()) ?>"><?php the_title(); ?></a></h3>
                                <h4><?php echo get_post_meta(get_the_ID(),'location',true);?></h4>
                            </div>
                        </div>
                    <?php endwhile;
                    endif;
                    ?>
                    </div>
                </div>
            </div>
        </section>
       <!-- ALL EVENTS SECTION END -->
<?php
get_footer(); ?>