<?php
/**
 * Lineup functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Lineup
 * @since Lineup 1.0
 */


if ( ! function_exists( 'lineup_support' ) ) :

	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * @since Lineup 1.0
	 *
	 * @return void
	 */
	function lineup_support() {

		// Enqueue editor styles.
		add_editor_style( 'style.css' );

		// Make theme available for translation.
		load_theme_textdomain( 'lineup' );
	}

endif;

add_action( 'after_setup_theme', 'lineup_support' );

if ( ! function_exists( 'lineup_styles' ) ) :

	/**
	 * Enqueue styles.
	 *
	 * @since Lineup 1.0
	 *
	 * @return void
	 */
	function lineup_styles() {

		// Register theme stylesheet.
		wp_register_style(
			'lineup-style',
			get_stylesheet_directory_uri() . '/style.css',
			array(),
			wp_get_theme()->get( 'Version' )
		);

		// Enqueue theme stylesheet.
		wp_enqueue_style( 'lineup-style' );

	}

endif;

add_action( 'wp_enqueue_scripts', 'lineup_styles' );


// updater for WordPress.com themes
if ( is_admin() )
	include dirname( __FILE__ ) . '/inc/updater.php';
