<?php
add_action("init","goldy_studio_hook",12);
function goldy_studio_hook(){
                             
	remove_action('goldy_our_portfolio_loop', 'goldy_mex_our_portfolio_loop', 5);

add_action('goldy_our_portfolio_loop', 'goldy_new_design_our_portfolio_loop', 5);
function goldy_new_design_our_portfolio_loop($info_item) {
?>
    <div class="new-portfolio-item-wrapper">
        <div class="new-portfolio-item">
            <div class="new-portfolio-image-wrapper">
                <?php if (!empty($info_item['image'])) { ?>
                    <img src="<?php echo esc_url($info_item['image']); ?>" alt="<?php echo esc_attr($info_item['title']); ?>" class="new-portfolio-image">
                <?php } else { ?>
                    <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/no-thumb.jpg" alt="No Thumbnail" class="new-portfolio-image"> 
                <?php } ?>
            </div>
            <div class="new-portfolio-content">
                <h3 class="new-portfolio-title"><?php echo esc_html($info_item['title']); ?></h3>
                <div class="new-portfolio-description">
                    <p><?php echo wp_kses_post($info_item['text']); ?></p>
                </div>
                <?php if (!empty($info_item['link_url'])) { ?>
                    <div class="new-portfolio-button">
                        <a href="<?php echo esc_url($info_item['link_url']); ?>" class="new-portfolio-read-more">
                            <?php _e('Read More', 'goldy-studio'); ?> <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
<?php
}


// Remove old testimonial loop
remove_action('goldy_our_testimonial_loop', 'goldy_mex_our_testimonial_loop', 5);

// Add new testimonial loop
add_action('goldy_our_testimonial_loop', 'goldy_studio_our_testimonial_loop', 5);

function goldy_studio_our_testimonial_loop($info_item) {
?>
    <div class="testimonial-container">
        <div class="testimonial-image-wrapper">
            <?php if (!empty($info_item['image'])): ?>
                <img src="<?php echo esc_url($info_item['image']); ?>" alt="Testimonial Image" class="testimonial-image">
            <?php else: ?>
                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/no-thumb.jpg" alt="Default Image" class="testimonial-image">
            <?php endif; ?>
        </div>
        <div class="testimonial-author-info">
                <h3><?php echo esc_html($info_item['title']); ?></h3>
                <h4><?php echo esc_attr($info_item['subtitle']); ?></h4>
            </div>
        <div class="testimonial-content">
            <div class="testimonial-text">
                <p><?php echo wp_kses_post($info_item['text']); ?></p>
            </div>
        </div>
        <div class="testimonial-quote-icon">
            <i class="fa fa-quote-left"></i>
        </div>
    </div>
<?php
}



}